<?php
use think\Db;
/**
 * 发表与修改表页面的自定义字段信息
 * @param number $mid
 * @param array $info 内容信息
 * @return array[]
 */
function get_all_field($dirname='',$mid=0,$info=[]){
	$array=[];
	$field_array=get_field($mid,$dirname);
	foreach($field_array AS $rs){
		//$rs['options'] && $rs['options'] = str_array($rs['options']);
		if($rs['type']=='usergroup2'||$rs['type']=='usergroup3'){    //用户组多选 及单选
			$rs['options']='app\common\model\Group@getTitleList';
		}
		$rs['options']=options_2array($rs['options'],$info);
		if($rs['type']=='hidden'){   //隐藏域比较特别些
			$rs['title']=$rs['value'];
		}
		if($rs['type']=='select'||$rs['type']=='radio'||$rs['type']=='checkbox'||$rs['type']=='checkboxtree'){
			$arr=[
				$rs['type'],
				$rs['name'],
				$rs['title'],
				$rs['about'],
				$rs['options'],
				$rs['value'],
			];
		}else{
			$arr=[
				$rs['type'],
				$rs['name'],
				$rs['title'],
				$rs['about'],
				$rs['value'],
				$rs['options']
			];
		}
		$array[]=$arr+$rs;
	}
	return $array;
}
/**
 * 把单选\多选\下拉框架的参数转义为可选项数组
 * @param string $str 可以是类 app\bbs\model\Sort@getTitleList
 * @param array $info 内容信息
 * @return void|string|array|unknown[]
 */
function options_2array($str='',$info=[]){
	if($str==''){
		return;
	}
	if(preg_match('/^[a-z]+(\\\[\w]+)+@[\w]+/',$str)){  //类似这种格式 app\xx\xx@action
		list($class_name,$action,$params)=explode('@',$str);
		if(class_exists($class_name)&&method_exists($class_name,$action)){
			$obj=new $class_name;
			if($params!=''){
				$_params=json_decode($params,true)?:fun('label@where',$params);
			}else{
				$_params=[];
			}
			//$_params = $params ? json_decode($params,true) : [] ;
			$array=call_user_func_array([$obj,$action],isset($_params[0])?$_params:[$_params]);
		}
	}elseif(preg_match('/^([\w]+)@([\w]+),([\w]+)/i',$str)){        //类似这种格式 cms_mysort@id,name@uid
		list($table_name,$fields,$params)=explode('@',$str);
		preg_match('/^qb_/i',$table_name)&&$table_name=str_replace('qb_','',$table_name);
		if($params=='uid'){ //特殊属性uid指定用户
			$map=[
				'uid'=>intval(($info&&$info['uid'])?$info['uid']:login_user('uid')) //修改的时候,就用回作者的UID
			];
		}elseif($params!=''){
			$map=json_decode($params,true)?:fun('label@where',$params);
		}
		is_array($map)||$map=[];
		$array=Db::name($table_name)->where($map)->column($fields);
	}elseif(!empty($array=json_decode($str,true))){
	}else{
		$array=str_array($str,"\n");
	}
	return $array;
}
/**
 * 对POST的数据进行转义处理
 * @param unknown $data
 * @return number
 */
function format_post_data($data,$mid=0){
	$field_array=get_field($mid);
	foreach($field_array as $rs){
		$value=\app\common\field\Post::format($rs,$data);
		if($value!==null){
			$data[$rs['name']]=$value;
		}
	}
	return $data;
}