<?php
namespace app\api\index;
use app\common\controller\ApiBase;
/**
 * CMS示例接口
 */
class Cms extends ApiBase{
	protected $model;//内容
	protected $s_model;//栏目
	protected $mid;
	protected $expires=300;//重置超时为5分钟
	protected function _initialize(){
		parent::_initialize();
		$this->model=get_model_class('cms','content');
		$this->s_model=get_model_class('cms','sort');
	}
	// 无需登录的接口,*表示全部
	protected $noNeedLogin=['index','getsort','getlist','getsons'];
	/**
	 * 首页 不需要登录
	 */
	public function index(){
		return $this->success('cms success');
	}
	/**
	 * 新增
	 * @param int $fid
	 * @param int $mid
	 * @return array|\think\response\Json|void
	 */
	public function post($fid=0,$mid=0){
		if($fid&&!$mid){ //根据栏目选择发表内容
			$mid=$this->model->getMidByFid($fid);
		}
		$this->mid=$mid;
		if($this->request->isPost()){
			$data=$this->request->post();
			$data=format_post_data($data,$this->mid);
			if(!empty($this->validate)){
				// 验证
				$result=$this->validate($data,$this->validate);
				if(true!==$result){
					$this->error($result);
				}
			}
			//接口
			hook_listen('cms_add_begin',$data);
			$data['uid']=$this->user['uid'];
			$data['mid']=$this->mid;
			$id=$this->model->addData($this->mid,$data);
			$this->success('添加成功');
			if(is_numeric($id)){
				//以下两行是接口
				hook_listen('cms_add_end',$id,['data'=>$data,'module'=>$this->request->module()]);
				$this->success('新增成功');
			}else{
				$this->error('新增失败:');
			}
		}
		$sort_array=$this->s_model->getTreeTitle(0,$mid);
		foreach($sort_array AS $key=>$title){
			$allowpost=get_sort($key,'allowpost');
			if($allowpost&&!in_array($this->user['groupid'],explode(',',$allowpost))){  //设置了用户组权限.
				unset($sort_array[$key]);
			}
		}
		$form_field=get_all_field('cms',$mid);
		$postdb=[
			'sort_array'=>$sort_array,
			'form_field'=>$form_field
		];
		return $this->ok_js($postdb);
	}
	/**
	 * 编辑
	 * @param $id
	 * @return array|\think\response\Json|void
	 */
	public function edit($id){
		$info=$this->model->getInfoByid($id);
		if(empty($info)){
			$this->error('内容不存在!');
		}
		if($info['uid']!=$this->user['uid']){
			return '你没权限!';
		}
		$this->mid=$info['mid'];
		if($this->request->isPost()){
			$data=$this->request->post();
			if(empty($data['id'])){
				$this->error('ID参数值不存在!!');
			}
			$data=format_post_data($data,$this->mid);
			$info=$this->model->getInfoByid($data['id']);
			$result=$this->model->editData($this->mid,$data);
			if($result){
				//以下两行是接口
				hook_listen('cms_edit_end',$data,['result'=>$result,'module'=>$this->request->module(),'info'=>$info]);
				$this->success('修改成功');
			}else{
				$this->error('修改无效');
			}
		}
		$sort_array=$this->s_model->getTreeTitle(0,$this->mid);
		foreach($sort_array AS $key=>$title){
			$allowpost=get_sort($key,'allowpost');
			if($key!=$info['fid']&&$allowpost&&!in_array($this->user['groupid'],explode(',',$allowpost))){  //设置了用户组权限.
				unset($sort_array[$key]);
			}
		}
		//发布页要填写的字段
		$form_field=get_all_field('cms',$this->mid);
		$postdb=[
			'sort_array'=>$sort_array,
			'form_field'=>$form_field,
			'info'      =>$info
		];
		return $this->ok_js($postdb);
	}
	/**
	 * 删除内容
	 * @param unknown $ids
	 */
	public function delete($id=0){
		$info=$this->model->getInfoByid($id);
		if(empty($info)){
			$this->error('内容不存在!');
		}
		if($info['uid']!=$this->user['uid']){
			return '你没权限!';
		}
		if($id){
			hook_listen('cms_delete_begin',$id);
			if ($this->model->deleteData($id,$info['mid'])) {
				hook_listen('cms_delete_end',$info,$this->request->module());
				$this->success('删除成功');
			}else{
				$this->error('删除失败');
			}
		}else{
			$this->error('请选择需要删除信息');
		}
	}

	/**
	 * 获取我的全部内容
	 * @param int $status 推荐等级
	 * @param int $type 排序
	 * @param int $rows 每页数据量
	 * @param int $page 分页
	 * @return array|\think\response\Json|void
	 */
	public function getmylist($status=1,$type='',$rows=10,$page=0){
		$map=$listdb=$array=[];
		$map['uid']=$this->user['uid'];
		$map['status']=$status;
		if($type=='hot'){
			$order='view desc';
		}elseif($type=='reply'){
			$order='list desc';
		}else{
			$order='id desc';
		}
		$array=getArray($this->model->getAll($map,$order,$rows,$page,true));
		foreach($array['data'] AS $key=>$rs){
			$rs2['id']=$rs['id'];
			$rs2['title']=$rs['title'];
			$rs2['url']=$rs['url'];
			$rs2['content']=get_word($rs['content'],400);
			$rs2['create_time']=date('Y-m-d H:i',$rs['create_time']);
			$rs2['picurl']=tempdir($rs['picurl']);
			$listdb['data'][$key]=$rs2;
		}
		return $this->ok_js($array);
	}
	/**
	 * 获取栏目 一级一级显示
	 * @param int $fid
	 * @return array|\think\response\Json|void
	 */
	public function getsort($fid=0){
		$listdb=getArray(sort_config('cms',$fid,true));
		return $this->ok_js($listdb);
	}
	/**
	 * 获取一级栏目 以及子栏目的全部内容
	 * @param int $fid 一级栏目fid
	 * @param int $status 推荐等级
	 * @param int $type 排序
	 * @param int $rows 每页数据量
	 * @param int $page 分页
	 * @return array|\think\response\Json|void
	 */
	public function getlist($fid=0,$status=1,$type='',$rows=10,$page=0){
		$map=$listdb=$array=[];
		$map['fid']=['in',array_values(get_sort($fid,'sons','','cms'))];
		$map['status']=$status;
		if($type=='hot'){
			$order='view desc';
		}elseif($type=='reply'){
			$order='list desc';
		}else{
			$order='id desc';
		}
		$array=getArray($this->model->getAll($map,$order,$rows,$page,true));
		foreach($array['data'] AS $key=>$rs){
			$rs2['id']=$rs['id'];
			$rs2['title']=$rs['title'];
			$rs2['url']=$rs['url'];
			$rs2['create_time']=date('Y-m-d H:i',$rs['create_time']);
			$rs2['picurl']=tempdir($rs['picurl']);
			$listdb['data'][$key]=$rs2;
		}
		return $this->ok_js($listdb['data']);
	}
	/**
	 * 获取下级栏目加自身下面的内容
	 * @param int $fid 栏目fid
	 * @param int $status 调用条件
	 * @param int $rows 调用数量
	 * @param int $type 排序
	 */
	public function getsons($fid=0,$status=1,$rows=2,$type=''){
		$arr1=$arr2=$softdb=$array=[];
		//获取下一级栏目 并加自身合并在一起
		$arr1=getArray(fun('Sort@son',intval($fid)));
		$arr2=[$fid=>get_sort($fid,'name')];
		$softdb=$arr2+$arr1;
		//不需要自身就把上面的注销 把这里打开 这里就是获取下面一级 没有下级就是自身
		//$softdb=getArray(fun('Sort@son',intval($fid))?:fun('Sort@brother',$fid));
		$map['status']=$status;
		if($type=='hot'){
			$order='view desc';
		}elseif($type=='reply'){
			$order='list desc';
		}else{
			$order='id desc';
		}
		foreach($softdb AS $key=>$rs){
			$rs2['fid']=$key;
			$rs2['name']=$rs;
			$rs2['sort_url']=iurl('cms/content/index',['fid'=>$key],true,false,'module');
			$map['fid']=$key;
			$arraydb=[];
			$array=getArray($this->model->getAll($map,$order,$rows,'',true));
			foreach($array['data'] AS $key3=>$vo){
				$vo2['id']=$vo['id'];
				$vo2['fid']=$vo['fid'];
				$vo2['title']=$vo['title'];
				$vo2['url']=$vo['url'];
				$vo2['picurl']=tempdir($vo['picurl']);
				$arraydb[$key3]=$vo2;
			}
			$rs2['listdb']=$arraydb;
			$listdb['data'][$key]=$rs2;
		}
		return $this->ok_js($listdb['data']);
	}
}
