<?php
namespace app\api\index;
use app\common\controller\ApiBase;
use app\api\model\User AS UserModel;
/**
 * 登录 退出示例接口
 */
class User extends ApiBase{
	// 无需登录的接口,*表示全部
	protected $noNeedLogin=['index','login','quit'];
	/**
	 * 首页 不需要登录
	 */
	public function index(){
		return $this->success('user success');
	}
	/**
	 * 登录接口不需要登录
	 */
	public function login(){
		if($this->request->isPost()){
			$data=$this->request->post();
			$result=UserModel::login($data['username'],$data['password'],$this->login_time);
			if($result==0){
				return $this->error("当前用户不存在,请重新输入");
			}elseif($result==-1){
				return $this->error("密码不正确,点击重新输入");
			}elseif(is_array($result)){
				$user=$result;
				$token=mymd5("{$user['uid']}\t{$user['username']}");
				unset($result['password']);//剔除密码和随机码
				unset($result['password_rand']);
				$array=[
					'uid'   =>$result['uid'],
					'result'=>$result,
					'token' =>$token,
				];
				session('login_token',$token);
				return $this->success('登录成功',$array);
			}else{
				return $this->error('未知错误!');
			}
		}else{
			return $this->error('提交方式有误!');
		}
	}
	/**
	 * 退出不需要登录
	 */
	public function quit(){
		UserModel::quit($this->user['uid']);
		return $this->success('退出成功');
	}
}
